﻿# Import list of Users From CSV into $Userlist
$UserList=IMPORT-CSV "C:\CRM\VABTSSS\Liberty ITS Users.csv"
 
# Step through Each Item in the List
FOREACH ($Person in $UserList) {
 
    # Build Username
    $Username=$Person.Username
 
    # Build Password from Firstname and Lastname
    $Password="Corp123!"
 
    # Build the Displayname
    $Name=$Person.Firstname +” “+ $Person.Lastname
    $SamAccountName = $Person.Firstname.Substring(0, 1) + $Person.Lastname
    Write-Host $Name
    Write-Host $SamAccountName
 
    # Build and define Domain name
    $Domain="@jeroberDomain.local"
     
    # Build User Principal Name
    $UPN=$Username+$Domain
 
    # Build and define Home Directory path
    $HDrive="\\uncpathtohomeshare\"
 
    # Build and define which Organizational Unit to create User inside
    $OU="OU=Dynamics,DC=jeroberDomain,DC=local"
 
    # Create Account in Active Directory (AND HERE...WE...GO!
    #New-ADUser -Name $Name –GivenName $Person.Firstname –Surname $Person.Lastname –DisplayName $Name –SamAccountName $Username -HomeDrive "H:" -HomeDirectory $HDrive –UserPrincipalName $UPN -Path $OU
    New-ADUser -Name $Name -SamAccountName $SamAccountName –GivenName $Person.Firstname –Surname $Person.Lastname –DisplayName $Name -HomeDrive $HDrive –UserPrincipalName $UPN -Path $OU

    # Set Password
    Set-ADAccountPassword -Identity $SamAccountName -NewPassword (ConvertTo-SecureString -AsPlainText $Password -Force)
 
    # Add User to Security Groups
    Add-ADPrincipalGroupMembership -Identity $SamAccountName -MemberOf "Administrators","Domain Admins"
    # Enable Account
    Enable-ADAccount -Identity $SamAccountName
 
}

